# Android Messaging (Tauri wrapper)

This repository provides a lightweight Tauri-based wrapper that opens the Android Messages web interface in a system WebView (WebKit on many Linux desktops). It is unofficial and not affiliated with Google or Android.

Quick start (development)

Requirements:

- Rust toolchain (rustup/cargo)
- Node.js + npm (for Tauri CLI)
- System WebKit dev packages on Linux (e.g., `webkit2gtk`, `gtk3`)

Commands:

```bash
# Install Rust toolchain (if not present)
curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh
source $HOME/.cargo/env

# Install tauri CLI globally
npm install -g @tauri-apps/cli

cd /home/natalie/Documents/google-messages/src-tauri
cargo run
```

Build (release):

```bash
cd /home/natalie/Documents/google-messages/src-tauri
cargo build --release
```

Packaging for Arch Linux (reproducible)

- A `PKGBUILD.tauri` is included to build the Tauri binary and package it for Arch.
- For a clean build environment use the included `Dockerfile.build` which installs the necessary system dependencies and builds the Tauri app inside an Arch container.

Example (local build using Docker):

```bash
docker build -t gm-build -f Dockerfile.build .
docker run --rm -v "$PWD/dist:/work/dist" gm-build
```

Notes & disclaimers

- This project only wraps the Google Messages web UI; it does not redistribute Google's server content or proprietary assets.
- The code here is licensed under the MIT license (see `LICENSE`).
- If you want a packaged Electron app instead, that was removed in favor of the lighter Tauri approach.

## AI Assist (Free & Local)

The app includes AI writing assistance for users with disabilities. By default it uses **Ollama** (free, runs locally):

1. Install Ollama: https://ollama.ai
2. Run: `ollama run llama3.2`
3. The AI Assist button will now work (no API keys needed!)

**Cloud AI Options:** You can also configure Claude, Gemini, ChatGPT, or GitHub Copilot through the settings menu. GitHub Copilot uses the same OAuth authentication as VS Code.

## Settings & Configuration

Access settings from the overlay menu. The app includes two settings tabs:

### AI Assistant Settings
- **AI Provider Selection**: Choose between Ollama (free/local), Claude, Gemini, ChatGPT, or GitHub Copilot
- **API Key Management**: Securely store API keys for cloud providers
- **GitHub OAuth**: One-click authentication for GitHub Copilot (just like VS Code)

### General Settings
- **Appearance**: Theme selection (System/Light/Dark)
- **Startup Behavior**: Auto-start on login, start minimized, minimize to tray
- **Notifications**: Desktop notifications and sounds
- **AI Behavior**: Enable/disable AI overlay, auto-suggest, keyboard shortcuts
- **Privacy**: Clear cache/cookies on exit

Settings are stored locally in `~/.config/android-messaging/`

Documentation

- Build and packaging instructions: `BUILDING.md`
- Architecture and security notes: `ELECTRON_EXPLAINER.md` (contains Tauri migration notes)
- You are not receiving or redistributing Google's code or assets in this package; you are packaging a wrapper that loads Google's web service in the user's runtime. By using this package you agree to comply with Google's Terms of Service for that site.
- The wrapper code provided here is licensed under the MIT license (see `LICENSE`). The Google Messages service, its UI, trademarks, and content remain the property of Google.
- If you prefer not to use this wrapper, you can access the service directly at `https://messages.google.com/web/conversations`.

Maintainer

Packager/maintainer: Natalie <natalie@acreetionos.org>

## Documentation

- Build and packaging instructions: `BUILDING.md`
- Electron architecture, security, and developer notes: `ELECTRON_EXPLAINER.md`
 - Key files: `PKGBUILD`, `LICENSE`, `desktop/google-messages-tauri.desktop`

Alternative backend: Tauri (WebKit-based on Linux)

If you want a lighter runtime using the system WebView (WebKit on Linux), consider migrating this wrapper to Tauri. Tauri uses the OS webview (WebKitGTK on many Linux desktops) which can reduce memory and startup time compared to bundling Chromium.

Quick scaffold (created in `src-tauri/`):

- `src-tauri/Cargo.toml` — Rust package manifest for the Tauri app
- `src-tauri/src/main.rs` — minimal Tauri `Window` that loads `https://messages.google.com/web/conversations`
- `src-tauri/tauri.conf.json` — basic Tauri config

Run the Tauri app for development (requirements: Rust toolchain, `cargo`, and `@tauri-apps/cli`):

```bash
# Install Rust toolchain (if not present)
curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh
source $HOME/.cargo/env

# Install tauri CLI (requires Node/npm) and dev deps
npm install -g @tauri-apps/cli

cd /home/natalie/Documents/google-messages/src-tauri
cargo build
cargo run
```

Notes and limitations:
- You will need `webkit2gtk`/`gtk3` development packages on Linux for the webview; install `webkit2gtk` via your distro package manager.
- Tauri's notification and native APIs differ from Electron; you can implement notifications via the `tauri::api::notification` module and communicate with the web content using `Window::eval` to inject scripts.
- Migration will require adapting the preload/IPC logic currently in `preload.js` to Tauri's command/event model.

Notifications & replies

- This wrapper implements a content observer that tries to detect incoming messages on the Google Messages web UI and sends native notifications via the system notification service.
- Replying from the notification is supported on platforms that provide a reply API (macOS has the best support; Linux support depends on the desktop environment and notification server). Replies are injected back into the web UI by executing a small script in the page.
- Limitations: the DOM selectors used to detect messages and to inject replies are heuristic and may break if Google changes their UI. The feature is best-effort and may require selector tuning.
- If notification replies fail on your system, the notification click will focus the app window so you can reply there.

Toggle notifications

- Use the application menu: open Options → Enable Notifications to enable or disable native notifications.
