/* appstream_plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from appstream_plugin.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <appstream.h>
#include <gio/gio.h>
#include "pamac-appstream.h"
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PAMAC_TYPE_APP (pamac_app_get_type ())
#define PAMAC_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_APP, PamacApp))
#define PAMAC_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_APP, PamacAppClass))
#define PAMAC_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_APP))
#define PAMAC_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_APP))
#define PAMAC_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_APP, PamacAppClass))

typedef struct _PamacApp PamacApp;
typedef struct _PamacAppClass PamacAppClass;
typedef struct _PamacAppPrivate PamacAppPrivate;

#define PAMAC_TYPE_APP_LINKED (pamac_app_linked_get_type ())
#define PAMAC_APP_LINKED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_APP_LINKED, PamacAppLinked))
#define PAMAC_APP_LINKED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_APP_LINKED, PamacAppLinkedClass))
#define PAMAC_IS_APP_LINKED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_APP_LINKED))
#define PAMAC_IS_APP_LINKED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_APP_LINKED))
#define PAMAC_APP_LINKED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_APP_LINKED, PamacAppLinkedClass))

typedef struct _PamacAppLinked PamacAppLinked;
typedef struct _PamacAppLinkedClass PamacAppLinkedClass;
typedef struct _PamacAppLinkedPrivate PamacAppLinkedPrivate;
enum  {
	PAMAC_APP_LINKED_0_PROPERTY,
	PAMAC_APP_LINKED_NAME_PROPERTY,
	PAMAC_APP_LINKED_ID_PROPERTY,
	PAMAC_APP_LINKED_PKGNAME_PROPERTY,
	PAMAC_APP_LINKED_DESC_PROPERTY,
	PAMAC_APP_LINKED_LONG_DESC_PROPERTY,
	PAMAC_APP_LINKED_REPO_PROPERTY,
	PAMAC_APP_LINKED_LAUNCHABLE_PROPERTY,
	PAMAC_APP_LINKED_ICON_PROPERTY,
	PAMAC_APP_LINKED_SCREENSHOTS_PROPERTY,
	PAMAC_APP_LINKED_NUM_PROPERTIES
};
static GParamSpec* pamac_app_linked_properties[PAMAC_APP_LINKED_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define PAMAC_TYPE_APPSTREAM_PLUGIN (pamac_appstream_plugin_get_type ())
#define PAMAC_APPSTREAM_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_APPSTREAM_PLUGIN, PamacAppstreamPlugin))
#define PAMAC_IS_APPSTREAM_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_APPSTREAM_PLUGIN))
#define PAMAC_APPSTREAM_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_APPSTREAM_PLUGIN, PamacAppstreamPluginIface))

typedef struct _PamacAppstreamPlugin PamacAppstreamPlugin;
typedef struct _PamacAppstreamPluginIface PamacAppstreamPluginIface;

#define PAMAC_TYPE_APPSTREAM (pamac_appstream_get_type ())
#define PAMAC_APPSTREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_APPSTREAM, PamacAppstream))
#define PAMAC_APPSTREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_APPSTREAM, PamacAppstreamClass))
#define PAMAC_IS_APPSTREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_APPSTREAM))
#define PAMAC_IS_APPSTREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_APPSTREAM))
#define PAMAC_APPSTREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_APPSTREAM, PamacAppstreamClass))

typedef struct _PamacAppstream PamacAppstream;
typedef struct _PamacAppstreamClass PamacAppstreamClass;
typedef struct _PamacAppstreamPrivate PamacAppstreamPrivate;
enum  {
	PAMAC_APPSTREAM_0_PROPERTY,
	PAMAC_APPSTREAM_NUM_PROPERTIES
};
static GParamSpec* pamac_appstream_properties[PAMAC_APPSTREAM_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _PamacApp {
	GObject parent_instance;
	PamacAppPrivate * priv;
};

struct _PamacAppClass {
	GObjectClass parent_class;
	const gchar* (*get_name) (PamacApp* self);
	const gchar* (*get_id) (PamacApp* self);
	const gchar* (*get_pkgname) (PamacApp* self);
	const gchar* (*get_desc) (PamacApp* self);
	const gchar* (*get_long_desc) (PamacApp* self);
	const gchar* (*get_repo) (PamacApp* self);
	const gchar* (*get_launchable) (PamacApp* self);
	const gchar* (*get_icon) (PamacApp* self);
	GPtrArray* (*get_screenshots) (PamacApp* self);
};

struct _PamacAppLinked {
	PamacApp parent_instance;
	PamacAppLinkedPrivate * priv;
};

struct _PamacAppLinkedClass {
	PamacAppClass parent_class;
};

struct _PamacAppLinkedPrivate {
	AsComponent* _as_app;
	const gchar* _name;
	const gchar* _id;
	const gchar* _pkgname;
	const gchar* _desc;
	gchar* _long_desc;
	const gchar* _repo;
	const gchar* _launchable;
	gchar* _icon;
	GPtrArray* _screenshots;
};

struct _PamacAppstreamPluginIface {
	GTypeInterface parent_iface;
	void (*load) (PamacAppstreamPlugin* self, GPtrArray* repos_names);
	GPtrArray* (*get_apps) (PamacAppstreamPlugin* self);
	GPtrArray* (*search) (PamacAppstreamPlugin* self, gchar** search_tokens, gint search_tokens_length1);
	GPtrArray* (*get_pkgname_apps) (PamacAppstreamPlugin* self, const gchar* pkgname);
	GHashTable* (*get_category_apps) (PamacAppstreamPlugin* self, const gchar* category);
};

struct _PamacAppstream {
	GObject parent_instance;
	PamacAppstreamPrivate * priv;
};

struct _PamacAppstreamClass {
	GObjectClass parent_class;
};

struct _PamacAppstreamPrivate {
	GPtrArray* stores_table;
	GHashTable* pkgname_apps_cache;
	GHashTable* categories_cache;
	GPtrArray* repos_names;
};

static gint PamacAppLinked_private_offset;
static gpointer pamac_app_linked_parent_class = NULL;
static gint PamacAppstream_private_offset;
static gpointer pamac_appstream_parent_class = NULL;
static PamacAppstreamPluginIface * pamac_appstream_pamac_appstream_plugin_parent_iface = NULL;

VALA_EXTERN GType pamac_app_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_app_linked_get_type (void) G_GNUC_CONST ;
VALA_EXTERN const gchar* pamac_app_get_name (PamacApp* self);
VALA_EXTERN const gchar* pamac_app_get_id (PamacApp* self);
VALA_EXTERN const gchar* pamac_app_get_pkgname (PamacApp* self);
VALA_EXTERN const gchar* pamac_app_get_desc (PamacApp* self);
VALA_EXTERN const gchar* pamac_app_get_long_desc (PamacApp* self);
VALA_EXTERN const gchar* pamac_app_get_repo (PamacApp* self);
VALA_EXTERN const gchar* pamac_app_get_launchable (PamacApp* self);
VALA_EXTERN const gchar* pamac_app_get_icon (PamacApp* self);
VALA_EXTERN GPtrArray* pamac_app_get_screenshots (PamacApp* self);
VALA_EXTERN PamacAppLinked* pamac_app_linked_new (AsComponent* as_app,
                                      const gchar* repo);
VALA_EXTERN PamacAppLinked* pamac_app_linked_construct (GType object_type,
                                            AsComponent* as_app,
                                            const gchar* repo);
VALA_EXTERN PamacApp* pamac_app_construct (GType object_type);
VALA_EXTERN guint pamac_app_linked_search_matches_all (PamacAppLinked* self,
                                           gchar** search_tokens,
                                           gint search_tokens_length1);
static void _g_free0_ (gpointer var);
static void pamac_app_linked_finalize (GObject * obj);
static GType pamac_app_linked_get_type_once (void);
static void _vala_pamac_app_linked_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
VALA_EXTERN GType pamac_appstream_plugin_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_appstream_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PamacAppstream* pamac_appstream_new (void);
VALA_EXTERN PamacAppstream* pamac_appstream_construct (GType object_type);
static void pamac_appstream_real_load (PamacAppstreamPlugin* base,
                                GPtrArray* repos_names);
static void _g_object_unref0_ (gpointer var);
static GPtrArray* pamac_appstream_real_get_apps (PamacAppstreamPlugin* base);
static GPtrArray* pamac_appstream_real_search (PamacAppstreamPlugin* base,
                                        gchar** search_tokens,
                                        gint search_tokens_length1);
static GPtrArray* pamac_appstream_real_get_pkgname_apps (PamacAppstreamPlugin* base,
                                                  const gchar* pkgname);
static GHashTable* pamac_appstream_real_get_category_apps (PamacAppstreamPlugin* base,
                                                    const gchar* category);
static GObject * pamac_appstream_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _g_hash_table_unref0_ (gpointer var);
static void _g_ptr_array_unref0_ (gpointer var);
VALA_EXTERN void pamac_appstream_plugin_load (PamacAppstreamPlugin* self,
                                  GPtrArray* repos_names);
VALA_EXTERN GPtrArray* pamac_appstream_plugin_get_apps (PamacAppstreamPlugin* self);
VALA_EXTERN GPtrArray* pamac_appstream_plugin_search (PamacAppstreamPlugin* self,
                                          gchar** search_tokens,
                                          gint search_tokens_length1);
VALA_EXTERN GPtrArray* pamac_appstream_plugin_get_pkgname_apps (PamacAppstreamPlugin* self,
                                                    const gchar* pkgname);
VALA_EXTERN GHashTable* pamac_appstream_plugin_get_category_apps (PamacAppstreamPlugin* self,
                                                      const gchar* category);
static void pamac_appstream_finalize (GObject * obj);
static GType pamac_appstream_get_type_once (void);

static inline gpointer
pamac_app_linked_get_instance_private (PamacAppLinked* self)
{
	return G_STRUCT_MEMBER_P (self, PamacAppLinked_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PamacAppLinked*
pamac_app_linked_construct (GType object_type,
                            AsComponent* as_app,
                            const gchar* repo)
{
	PamacAppLinked * self = NULL;
	AsComponent* _tmp0_;
	self = (PamacAppLinked*) pamac_app_construct (object_type);
	_tmp0_ = _g_object_ref0 (as_app);
	_g_object_unref0 (self->priv->_as_app);
	self->priv->_as_app = _tmp0_;
	self->priv->_repo = repo;
	return self;
}

PamacAppLinked*
pamac_app_linked_new (AsComponent* as_app,
                      const gchar* repo)
{
	return pamac_app_linked_construct (PAMAC_TYPE_APP_LINKED, as_app, repo);
}

guint
pamac_app_linked_search_matches_all (PamacAppLinked* self,
                                     gchar** search_tokens,
                                     gint search_tokens_length1)
{
	AsComponent* _tmp0_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_as_app;
	result = as_component_search_matches_all (_tmp0_, search_tokens);
	return result;
}

static const gchar*
pamac_app_linked_real_get_name (PamacApp* base)
{
	const gchar* result;
	PamacAppLinked* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	self = (PamacAppLinked*) base;
	_tmp1_ = self->priv->_name;
	if (_tmp1_ == NULL) {
		AsComponent* _tmp2_;
		_tmp2_ = self->priv->_as_app;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AsComponent* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_as_app;
		_tmp4_ = as_component_get_name (_tmp3_);
		self->priv->_name = _tmp4_;
	}
	_tmp5_ = self->priv->_name;
	result = _tmp5_;
	return result;
}

static const gchar*
pamac_app_linked_real_get_id (PamacApp* base)
{
	const gchar* result;
	PamacAppLinked* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	self = (PamacAppLinked*) base;
	_tmp1_ = self->priv->_id;
	if (_tmp1_ == NULL) {
		AsComponent* _tmp2_;
		_tmp2_ = self->priv->_as_app;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AsComponent* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_as_app;
		_tmp4_ = as_component_get_id (_tmp3_);
		self->priv->_id = _tmp4_;
	}
	_tmp5_ = self->priv->_id;
	result = _tmp5_;
	return result;
}

static const gchar*
pamac_app_linked_real_get_pkgname (PamacApp* base)
{
	const gchar* result;
	PamacAppLinked* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	self = (PamacAppLinked*) base;
	_tmp1_ = self->priv->_pkgname;
	if (_tmp1_ == NULL) {
		AsComponent* _tmp2_;
		_tmp2_ = self->priv->_as_app;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AsComponent* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_as_app;
		_tmp4_ = as_component_get_pkgname (_tmp3_);
		self->priv->_pkgname = _tmp4_;
	}
	_tmp5_ = self->priv->_pkgname;
	result = _tmp5_;
	return result;
}

static const gchar*
pamac_app_linked_real_get_desc (PamacApp* base)
{
	const gchar* result;
	PamacAppLinked* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	self = (PamacAppLinked*) base;
	_tmp1_ = self->priv->_desc;
	if (_tmp1_ == NULL) {
		AsComponent* _tmp2_;
		_tmp2_ = self->priv->_as_app;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AsComponent* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_as_app;
		_tmp4_ = as_component_get_summary (_tmp3_);
		self->priv->_desc = _tmp4_;
	}
	_tmp5_ = self->priv->_desc;
	result = _tmp5_;
	return result;
}

static const gchar*
pamac_app_linked_real_get_long_desc (PamacApp* base)
{
	const gchar* result;
	PamacAppLinked* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	self = (PamacAppLinked*) base;
	_tmp1_ = self->priv->_long_desc;
	if (_tmp1_ == NULL) {
		AsComponent* _tmp2_;
		_tmp2_ = self->priv->_as_app;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			gchar* _tmp3_ = NULL;
			AsComponent* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = self->priv->_as_app;
			_tmp5_ = as_component_get_description (_tmp4_);
			_tmp6_ = as_markup_convert (_tmp5_, AS_MARKUP_KIND_MARKDOWN, &_inner_error0_);
			_tmp3_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp3_;
			_tmp3_ = NULL;
			_g_free0 (self->priv->_long_desc);
			self->priv->_long_desc = _tmp7_;
			_g_free0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("appstream_plugin.vala:74: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = self->priv->_long_desc;
	result = _tmp10_;
	return result;
}

static const gchar*
pamac_app_linked_real_get_repo (PamacApp* base)
{
	const gchar* result;
	PamacAppLinked* self;
	const gchar* _tmp0_;
	self = (PamacAppLinked*) base;
	_tmp0_ = self->priv->_repo;
	result = _tmp0_;
	return result;
}

static const gchar*
pamac_app_linked_real_get_launchable (PamacApp* base)
{
	const gchar* result;
	PamacAppLinked* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp10_;
	self = (PamacAppLinked*) base;
	_tmp1_ = self->priv->_launchable;
	if (_tmp1_ == NULL) {
		AsComponent* _tmp2_;
		_tmp2_ = self->priv->_as_app;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AsLaunchable* as_launchable = NULL;
		AsComponent* _tmp3_;
		AsLaunchable* _tmp4_;
		AsLaunchable* _tmp5_;
		_tmp3_ = self->priv->_as_app;
		_tmp4_ = as_component_get_launchable (_tmp3_, AS_LAUNCHABLE_KIND_DESKTOP_ID);
		as_launchable = _tmp4_;
		_tmp5_ = as_launchable;
		if (_tmp5_ != NULL) {
			GPtrArray* entries = NULL;
			AsLaunchable* _tmp6_;
			GPtrArray* _tmp7_;
			GPtrArray* _tmp8_;
			_tmp6_ = as_launchable;
			_tmp7_ = as_launchable_get_entries (_tmp6_);
			entries = _tmp7_;
			_tmp8_ = entries;
			{
				GPtrArray* entry_collection = NULL;
				guint entry_index = 0U;
				entry_collection = _tmp8_;
				for (entry_index = 0; entry_index < entry_collection->len; entry_index = entry_index + 1) {
					const gchar* entry = NULL;
					entry = (const gchar*) g_ptr_array_index (entry_collection, entry_index);
					{
						const gchar* _tmp9_;
						_tmp9_ = entry;
						self->priv->_launchable = _tmp9_;
						break;
					}
				}
			}
		}
	}
	_tmp10_ = self->priv->_launchable;
	result = _tmp10_;
	return result;
}

static const gchar*
pamac_app_linked_real_get_icon (PamacApp* base)
{
	const gchar* result;
	PamacAppLinked* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp14_;
	self = (PamacAppLinked*) base;
	_tmp2_ = self->priv->_icon;
	if (_tmp2_ == NULL) {
		AsComponent* _tmp3_;
		_tmp3_ = self->priv->_as_app;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->_repo;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GPtrArray* as_icons = NULL;
		AsComponent* _tmp5_;
		GPtrArray* _tmp6_;
		GPtrArray* _tmp7_;
		_tmp5_ = self->priv->_as_app;
		_tmp6_ = as_component_get_icons (_tmp5_);
		as_icons = _tmp6_;
		_tmp7_ = as_icons;
		{
			GPtrArray* as_icon_collection = NULL;
			guint as_icon_index = 0U;
			as_icon_collection = _tmp7_;
			for (as_icon_index = 0; as_icon_index < as_icon_collection->len; as_icon_index = as_icon_index + 1) {
				AsIcon* as_icon = NULL;
				as_icon = (AsIcon*) g_ptr_array_index (as_icon_collection, as_icon_index);
				{
					AsIcon* _tmp8_;
					_tmp8_ = as_icon;
					if (as_icon_get_kind (_tmp8_) == AS_ICON_KIND_CACHED) {
						AsIcon* _tmp9_;
						_tmp9_ = as_icon;
						if (as_icon_get_height (_tmp9_) == ((guint) 64)) {
							const gchar* _tmp10_;
							AsIcon* _tmp11_;
							const gchar* _tmp12_;
							gchar* _tmp13_;
							_tmp10_ = self->priv->_repo;
							_tmp11_ = as_icon;
							_tmp12_ = as_icon_get_name (_tmp11_);
							_tmp13_ = g_strdup_printf ("/usr/share/swcatalog/icons/archlinux-arch-%s/64x64/%s", _tmp10_, _tmp12_);
							_g_free0 (self->priv->_icon);
							self->priv->_icon = _tmp13_;
							break;
						}
					}
				}
			}
		}
	}
	_tmp14_ = self->priv->_icon;
	result = _tmp14_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GPtrArray*
pamac_app_linked_real_get_screenshots (PamacApp* base)
{
	GPtrArray* result;
	PamacAppLinked* self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp15_;
	self = (PamacAppLinked*) base;
	_tmp0_ = self->priv->_screenshots;
	if (_tmp0_ == NULL) {
		GPtrArray* _tmp1_;
		AsComponent* _tmp2_;
		_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_g_ptr_array_unref0 (self->priv->_screenshots);
		self->priv->_screenshots = _tmp1_;
		_tmp2_ = self->priv->_as_app;
		if (_tmp2_ != NULL) {
			GPtrArray* as_screenshots = NULL;
			AsComponent* _tmp3_;
			GPtrArray* _tmp4_;
			GPtrArray* _tmp5_;
			_tmp3_ = self->priv->_as_app;
			_tmp4_ = as_component_get_screenshots_all (_tmp3_);
			as_screenshots = _tmp4_;
			_tmp5_ = as_screenshots;
			{
				GPtrArray* as_screenshot_collection = NULL;
				guint as_screenshot_index = 0U;
				as_screenshot_collection = _tmp5_;
				for (as_screenshot_index = 0; as_screenshot_index < as_screenshot_collection->len; as_screenshot_index = as_screenshot_index + 1) {
					AsScreenshot* as_screenshot = NULL;
					as_screenshot = (AsScreenshot*) g_ptr_array_index (as_screenshot_collection, as_screenshot_index);
					{
						GPtrArray* as_images = NULL;
						AsScreenshot* _tmp6_;
						GPtrArray* _tmp7_;
						GPtrArray* _tmp8_;
						_tmp6_ = as_screenshot;
						_tmp7_ = as_screenshot_get_images (_tmp6_);
						as_images = _tmp7_;
						_tmp8_ = as_images;
						{
							GPtrArray* as_image_collection = NULL;
							guint as_image_index = 0U;
							as_image_collection = _tmp8_;
							for (as_image_index = 0; as_image_index < as_image_collection->len; as_image_index = as_image_index + 1) {
								AsImage* as_image = NULL;
								as_image = (AsImage*) g_ptr_array_index (as_image_collection, as_image_index);
								{
									const gchar* url = NULL;
									AsImage* _tmp9_;
									const gchar* _tmp10_;
									const gchar* _tmp11_;
									_tmp9_ = as_image;
									_tmp10_ = as_image_get_url (_tmp9_);
									url = _tmp10_;
									_tmp11_ = url;
									if (_tmp11_ != NULL) {
										GPtrArray* _tmp12_;
										const gchar* _tmp13_;
										gchar* _tmp14_;
										_tmp12_ = self->priv->_screenshots;
										_tmp13_ = url;
										_tmp14_ = g_strdup (_tmp13_);
										g_ptr_array_add (_tmp12_, _tmp14_);
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp15_ = self->priv->_screenshots;
	result = _tmp15_;
	return result;
}

static void
pamac_app_linked_class_init (PamacAppLinkedClass * klass,
                             gpointer klass_data)
{
	pamac_app_linked_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacAppLinked_private_offset);
	PAMAC_APP_CLASS (klass)->get_name = (const gchar* (*) (PamacApp*)) pamac_app_linked_real_get_name;
	PAMAC_APP_CLASS (klass)->get_id = (const gchar* (*) (PamacApp*)) pamac_app_linked_real_get_id;
	PAMAC_APP_CLASS (klass)->get_pkgname = (const gchar* (*) (PamacApp*)) pamac_app_linked_real_get_pkgname;
	PAMAC_APP_CLASS (klass)->get_desc = (const gchar* (*) (PamacApp*)) pamac_app_linked_real_get_desc;
	PAMAC_APP_CLASS (klass)->get_long_desc = (const gchar* (*) (PamacApp*)) pamac_app_linked_real_get_long_desc;
	PAMAC_APP_CLASS (klass)->get_repo = (const gchar* (*) (PamacApp*)) pamac_app_linked_real_get_repo;
	PAMAC_APP_CLASS (klass)->get_launchable = (const gchar* (*) (PamacApp*)) pamac_app_linked_real_get_launchable;
	PAMAC_APP_CLASS (klass)->get_icon = (const gchar* (*) (PamacApp*)) pamac_app_linked_real_get_icon;
	PAMAC_APP_CLASS (klass)->get_screenshots = (GPtrArray* (*) (PamacApp*)) pamac_app_linked_real_get_screenshots;
	G_OBJECT_CLASS (klass)->get_property = _vala_pamac_app_linked_get_property;
	G_OBJECT_CLASS (klass)->finalize = pamac_app_linked_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_APP_LINKED_NAME_PROPERTY, pamac_app_linked_properties[PAMAC_APP_LINKED_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_APP_LINKED_ID_PROPERTY, pamac_app_linked_properties[PAMAC_APP_LINKED_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_APP_LINKED_PKGNAME_PROPERTY, pamac_app_linked_properties[PAMAC_APP_LINKED_PKGNAME_PROPERTY] = g_param_spec_string ("pkgname", "pkgname", "pkgname", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_APP_LINKED_DESC_PROPERTY, pamac_app_linked_properties[PAMAC_APP_LINKED_DESC_PROPERTY] = g_param_spec_string ("desc", "desc", "desc", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_APP_LINKED_LONG_DESC_PROPERTY, pamac_app_linked_properties[PAMAC_APP_LINKED_LONG_DESC_PROPERTY] = g_param_spec_string ("long-desc", "long-desc", "long-desc", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_APP_LINKED_REPO_PROPERTY, pamac_app_linked_properties[PAMAC_APP_LINKED_REPO_PROPERTY] = g_param_spec_string ("repo", "repo", "repo", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_APP_LINKED_LAUNCHABLE_PROPERTY, pamac_app_linked_properties[PAMAC_APP_LINKED_LAUNCHABLE_PROPERTY] = g_param_spec_string ("launchable", "launchable", "launchable", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_APP_LINKED_ICON_PROPERTY, pamac_app_linked_properties[PAMAC_APP_LINKED_ICON_PROPERTY] = g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_APP_LINKED_SCREENSHOTS_PROPERTY, pamac_app_linked_properties[PAMAC_APP_LINKED_SCREENSHOTS_PROPERTY] = g_param_spec_boxed ("screenshots", "screenshots", "screenshots", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
pamac_app_linked_instance_init (PamacAppLinked * self,
                                gpointer klass)
{
	self->priv = pamac_app_linked_get_instance_private (self);
}

static void
pamac_app_linked_finalize (GObject * obj)
{
	PamacAppLinked * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_APP_LINKED, PamacAppLinked);
	_g_object_unref0 (self->priv->_as_app);
	_g_free0 (self->priv->_long_desc);
	_g_free0 (self->priv->_icon);
	_g_ptr_array_unref0 (self->priv->_screenshots);
	G_OBJECT_CLASS (pamac_app_linked_parent_class)->finalize (obj);
}

static GType
pamac_app_linked_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacAppLinkedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_app_linked_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacAppLinked), 0, (GInstanceInitFunc) pamac_app_linked_instance_init, NULL };
	GType pamac_app_linked_type_id;
	pamac_app_linked_type_id = g_type_register_static (PAMAC_TYPE_APP, "PamacAppLinked", &g_define_type_info, 0);
	PamacAppLinked_private_offset = g_type_add_instance_private (pamac_app_linked_type_id, sizeof (PamacAppLinkedPrivate));
	return pamac_app_linked_type_id;
}

GType
pamac_app_linked_get_type (void)
{
	static volatile gsize pamac_app_linked_type_id__once = 0;
	if (g_once_init_enter (&pamac_app_linked_type_id__once)) {
		GType pamac_app_linked_type_id;
		pamac_app_linked_type_id = pamac_app_linked_get_type_once ();
		g_once_init_leave (&pamac_app_linked_type_id__once, pamac_app_linked_type_id);
	}
	return pamac_app_linked_type_id__once;
}

static void
_vala_pamac_app_linked_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	PamacAppLinked * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_APP_LINKED, PamacAppLinked);
	switch (property_id) {
		case PAMAC_APP_LINKED_NAME_PROPERTY:
		g_value_set_string (value, pamac_app_get_name ((PamacApp*) self));
		break;
		case PAMAC_APP_LINKED_ID_PROPERTY:
		g_value_set_string (value, pamac_app_get_id ((PamacApp*) self));
		break;
		case PAMAC_APP_LINKED_PKGNAME_PROPERTY:
		g_value_set_string (value, pamac_app_get_pkgname ((PamacApp*) self));
		break;
		case PAMAC_APP_LINKED_DESC_PROPERTY:
		g_value_set_string (value, pamac_app_get_desc ((PamacApp*) self));
		break;
		case PAMAC_APP_LINKED_LONG_DESC_PROPERTY:
		g_value_set_string (value, pamac_app_get_long_desc ((PamacApp*) self));
		break;
		case PAMAC_APP_LINKED_REPO_PROPERTY:
		g_value_set_string (value, pamac_app_get_repo ((PamacApp*) self));
		break;
		case PAMAC_APP_LINKED_LAUNCHABLE_PROPERTY:
		g_value_set_string (value, pamac_app_get_launchable ((PamacApp*) self));
		break;
		case PAMAC_APP_LINKED_ICON_PROPERTY:
		g_value_set_string (value, pamac_app_get_icon ((PamacApp*) self));
		break;
		case PAMAC_APP_LINKED_SCREENSHOTS_PROPERTY:
		g_value_set_boxed (value, pamac_app_get_screenshots ((PamacApp*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
pamac_appstream_get_instance_private (PamacAppstream* self)
{
	return G_STRUCT_MEMBER_P (self, PamacAppstream_private_offset);
}

PamacAppstream*
pamac_appstream_construct (GType object_type)
{
	PamacAppstream * self = NULL;
	self = (PamacAppstream*) g_object_new (object_type, NULL);
	return self;
}

PamacAppstream*
pamac_appstream_new (void)
{
	return pamac_appstream_construct (PAMAC_TYPE_APPSTREAM);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
pamac_appstream_real_load (PamacAppstreamPlugin* base,
                           GPtrArray* repos_names)
{
	PamacAppstream * self;
	GPtrArray* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* _tmp11_;
	gchar* _tmp12_;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GHashTable* _tmp15_;
	GHashTable* _tmp16_;
	gchar* _tmp17_;
	GHashFunc _tmp18_;
	GEqualFunc _tmp19_;
	GHashTable* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	GHashFunc _tmp23_;
	GEqualFunc _tmp24_;
	GHashTable* _tmp25_;
	GHashTable* _tmp26_;
	gchar* _tmp27_;
	GHashFunc _tmp28_;
	GEqualFunc _tmp29_;
	GHashTable* _tmp30_;
	GHashTable* _tmp31_;
	gchar* _tmp32_;
	GHashFunc _tmp33_;
	GEqualFunc _tmp34_;
	GHashTable* _tmp35_;
	GHashTable* _tmp36_;
	gchar* _tmp37_;
	GHashFunc _tmp38_;
	GEqualFunc _tmp39_;
	GHashTable* _tmp40_;
	GError* _inner_error0_ = NULL;
	self = (PamacAppstream*) base;
	g_return_if_fail (repos_names != NULL);
	_tmp0_ = _g_ptr_array_ref0 (repos_names);
	_g_ptr_array_unref0 (self->priv->repos_names);
	self->priv->repos_names = _tmp0_;
	_tmp1_ = self->priv->categories_cache;
	_tmp2_ = g_strdup ("Photo & Video");
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, NULL);
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp5_);
	_tmp6_ = self->priv->categories_cache;
	_tmp7_ = g_strdup ("Music & Audio");
	_tmp8_ = g_str_hash;
	_tmp9_ = g_str_equal;
	_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, NULL, NULL);
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp10_);
	_tmp11_ = self->priv->categories_cache;
	_tmp12_ = g_strdup ("Productivity");
	_tmp13_ = g_str_hash;
	_tmp14_ = g_str_equal;
	_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, NULL, NULL);
	g_hash_table_insert (_tmp11_, _tmp12_, _tmp15_);
	_tmp16_ = self->priv->categories_cache;
	_tmp17_ = g_strdup ("Communication & News");
	_tmp18_ = g_str_hash;
	_tmp19_ = g_str_equal;
	_tmp20_ = g_hash_table_new_full (_tmp18_, _tmp19_, NULL, NULL);
	g_hash_table_insert (_tmp16_, _tmp17_, _tmp20_);
	_tmp21_ = self->priv->categories_cache;
	_tmp22_ = g_strdup ("Education & Science");
	_tmp23_ = g_str_hash;
	_tmp24_ = g_str_equal;
	_tmp25_ = g_hash_table_new_full (_tmp23_, _tmp24_, NULL, NULL);
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp25_);
	_tmp26_ = self->priv->categories_cache;
	_tmp27_ = g_strdup ("Games");
	_tmp28_ = g_str_hash;
	_tmp29_ = g_str_equal;
	_tmp30_ = g_hash_table_new_full (_tmp28_, _tmp29_, NULL, NULL);
	g_hash_table_insert (_tmp26_, _tmp27_, _tmp30_);
	_tmp31_ = self->priv->categories_cache;
	_tmp32_ = g_strdup ("Utilities");
	_tmp33_ = g_str_hash;
	_tmp34_ = g_str_equal;
	_tmp35_ = g_hash_table_new_full (_tmp33_, _tmp34_, NULL, NULL);
	g_hash_table_insert (_tmp31_, _tmp32_, _tmp35_);
	_tmp36_ = self->priv->categories_cache;
	_tmp37_ = g_strdup ("Development");
	_tmp38_ = g_str_hash;
	_tmp39_ = g_str_equal;
	_tmp40_ = g_hash_table_new_full (_tmp38_, _tmp39_, NULL, NULL);
	g_hash_table_insert (_tmp36_, _tmp37_, _tmp40_);
	{
		GPtrArray* repo_collection = NULL;
		guint repo_index = 0U;
		repo_collection = repos_names;
		for (repo_index = 0; repo_index < repo_collection->len; repo_index = repo_index + 1) {
			const gchar* repo = NULL;
			repo = (const gchar*) g_ptr_array_index (repo_collection, repo_index);
			{
				{
					GFile* appstream_file = NULL;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					GFile* _tmp44_;
					GFile* _tmp45_;
					GFile* _tmp46_;
					_tmp41_ = repo;
					_tmp42_ = g_strdup_printf ("/usr/share/swcatalog/xml/%s.xml.gz", _tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = g_file_new_for_path (_tmp43_);
					_tmp45_ = _tmp44_;
					_g_free0 (_tmp43_);
					appstream_file = _tmp45_;
					_tmp46_ = appstream_file;
					if (g_file_query_exists (_tmp46_, NULL)) {
						AsMetadata* mdata = NULL;
						AsMetadata* _tmp47_;
						AsMetadata* _tmp48_;
						AsMetadata* _tmp49_;
						GFile* _tmp50_;
						GHashTable* desktop_apps = NULL;
						GHashFunc _tmp51_;
						GEqualFunc _tmp52_;
						GHashTable* _tmp53_;
						GPtrArray* apps = NULL;
						AsMetadata* _tmp54_;
						AsComponentBox* _tmp55_;
						GPtrArray* _tmp56_;
						GPtrArray* _tmp57_;
						GPtrArray* _tmp124_;
						GHashTable* _tmp125_;
						GHashTable* _tmp126_;
						_tmp47_ = as_metadata_new ();
						mdata = _tmp47_;
						_tmp48_ = mdata;
						as_metadata_set_format_style (_tmp48_, AS_FORMAT_STYLE_CATALOG);
						_tmp49_ = mdata;
						_tmp50_ = appstream_file;
						as_metadata_parse_file (_tmp49_, _tmp50_, AS_FORMAT_KIND_XML, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (mdata);
							_g_object_unref0 (appstream_file);
							goto __catch0_g_error;
						}
						_tmp51_ = g_str_hash;
						_tmp52_ = g_str_equal;
						_tmp53_ = g_hash_table_new_full (_tmp51_, _tmp52_, NULL, _g_object_unref0_);
						desktop_apps = _tmp53_;
						_tmp54_ = mdata;
						_tmp55_ = as_metadata_get_components (_tmp54_);
						_tmp56_ = as_component_box_as_array (_tmp55_);
						apps = _tmp56_;
						_tmp57_ = apps;
						{
							GPtrArray* app_collection = NULL;
							guint app_index = 0U;
							app_collection = _tmp57_;
							for (app_index = 0; app_index < app_collection->len; app_index = app_index + 1) {
								AsComponent* app = NULL;
								app = (AsComponent*) g_ptr_array_index (app_collection, app_index);
								{
									AsComponent* _tmp58_;
									_tmp58_ = app;
									if (as_component_get_kind (_tmp58_) == AS_COMPONENT_KIND_DESKTOP_APP) {
										const gchar* pkgname = NULL;
										AsComponent* _tmp59_;
										const gchar* _tmp60_;
										const gchar* _tmp61_;
										GPtrArray* pkgname_apps = NULL;
										GHashTable* _tmp62_;
										const gchar* _tmp63_;
										gconstpointer _tmp64_;
										GPtrArray* _tmp65_;
										GPtrArray* _tmp66_;
										PamacAppLinked* new_app = NULL;
										AsComponent* _tmp73_;
										const gchar* _tmp74_;
										PamacAppLinked* _tmp75_;
										GPtrArray* _tmp76_;
										PamacAppLinked* _tmp77_;
										const gchar* id = NULL;
										PamacAppLinked* _tmp78_;
										const gchar* _tmp79_;
										const gchar* _tmp80_;
										GHashTable* _tmp81_;
										const gchar* _tmp82_;
										PamacAppLinked* _tmp83_;
										PamacApp* _tmp84_;
										GPtrArray* app_categories = NULL;
										AsComponent* _tmp85_;
										GPtrArray* _tmp86_;
										GPtrArray* _tmp87_;
										_tmp59_ = app;
										_tmp60_ = as_component_get_pkgname (_tmp59_);
										pkgname = _tmp60_;
										_tmp61_ = pkgname;
										if (_tmp61_ == NULL) {
											continue;
										}
										_tmp62_ = self->priv->pkgname_apps_cache;
										_tmp63_ = pkgname;
										_tmp64_ = g_hash_table_lookup (_tmp62_, _tmp63_);
										_tmp65_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp64_);
										pkgname_apps = _tmp65_;
										_tmp66_ = pkgname_apps;
										if (_tmp66_ == NULL) {
											GPtrArray* _tmp67_;
											GHashTable* _tmp68_;
											const gchar* _tmp69_;
											gchar* _tmp70_;
											GPtrArray* _tmp71_;
											GPtrArray* _tmp72_;
											_tmp67_ = g_ptr_array_new_full ((guint) 0, NULL);
											_g_ptr_array_unref0 (pkgname_apps);
											pkgname_apps = _tmp67_;
											_tmp68_ = self->priv->pkgname_apps_cache;
											_tmp69_ = pkgname;
											_tmp70_ = g_strdup (_tmp69_);
											_tmp71_ = pkgname_apps;
											_tmp72_ = _g_ptr_array_ref0 (_tmp71_);
											g_hash_table_insert (_tmp68_, _tmp70_, _tmp72_);
										}
										_tmp73_ = app;
										_tmp74_ = repo;
										_tmp75_ = pamac_app_linked_new (_tmp73_, _tmp74_);
										new_app = _tmp75_;
										_tmp76_ = pkgname_apps;
										_tmp77_ = new_app;
										g_ptr_array_add (_tmp76_, (PamacApp*) _tmp77_);
										_tmp78_ = new_app;
										_tmp79_ = pamac_app_get_id ((PamacApp*) _tmp78_);
										_tmp80_ = _tmp79_;
										id = _tmp80_;
										_tmp81_ = desktop_apps;
										_tmp82_ = id;
										_tmp83_ = new_app;
										_tmp84_ = _g_object_ref0 ((PamacApp*) _tmp83_);
										g_hash_table_insert (_tmp81_, _tmp82_, _tmp84_);
										_tmp85_ = app;
										_tmp86_ = as_component_get_categories (_tmp85_);
										app_categories = _tmp86_;
										_tmp87_ = app_categories;
										{
											GPtrArray* cat_collection = NULL;
											guint cat_index = 0U;
											cat_collection = _tmp87_;
											for (cat_index = 0; cat_index < cat_collection->len; cat_index = cat_index + 1) {
												const gchar* cat = NULL;
												cat = (const gchar*) g_ptr_array_index (cat_collection, cat_index);
												{
													const gchar* _tmp88_;
													const gchar* _tmp89_;
													GQuark _tmp91_ = 0U;
													static GQuark _tmp90_label0 = 0;
													static GQuark _tmp90_label1 = 0;
													static GQuark _tmp90_label2 = 0;
													static GQuark _tmp90_label3 = 0;
													static GQuark _tmp90_label4 = 0;
													static GQuark _tmp90_label5 = 0;
													static GQuark _tmp90_label6 = 0;
													static GQuark _tmp90_label7 = 0;
													static GQuark _tmp90_label8 = 0;
													static GQuark _tmp90_label9 = 0;
													static GQuark _tmp90_label10 = 0;
													static GQuark _tmp90_label11 = 0;
													static GQuark _tmp90_label12 = 0;
													static GQuark _tmp90_label13 = 0;
													static GQuark _tmp90_label14 = 0;
													static GQuark _tmp90_label15 = 0;
													static GQuark _tmp90_label16 = 0;
													static GQuark _tmp90_label17 = 0;
													static GQuark _tmp90_label18 = 0;
													static GQuark _tmp90_label19 = 0;
													static GQuark _tmp90_label20 = 0;
													static GQuark _tmp90_label21 = 0;
													static GQuark _tmp90_label22 = 0;
													static GQuark _tmp90_label23 = 0;
													static GQuark _tmp90_label24 = 0;
													static GQuark _tmp90_label25 = 0;
													static GQuark _tmp90_label26 = 0;
													static GQuark _tmp90_label27 = 0;
													static GQuark _tmp90_label28 = 0;
													static GQuark _tmp90_label29 = 0;
													static GQuark _tmp90_label30 = 0;
													static GQuark _tmp90_label31 = 0;
													static GQuark _tmp90_label32 = 0;
													static GQuark _tmp90_label33 = 0;
													static GQuark _tmp90_label34 = 0;
													static GQuark _tmp90_label35 = 0;
													static GQuark _tmp90_label36 = 0;
													static GQuark _tmp90_label37 = 0;
													static GQuark _tmp90_label38 = 0;
													static GQuark _tmp90_label39 = 0;
													static GQuark _tmp90_label40 = 0;
													static GQuark _tmp90_label41 = 0;
													static GQuark _tmp90_label42 = 0;
													static GQuark _tmp90_label43 = 0;
													static GQuark _tmp90_label44 = 0;
													static GQuark _tmp90_label45 = 0;
													static GQuark _tmp90_label46 = 0;
													static GQuark _tmp90_label47 = 0;
													static GQuark _tmp90_label48 = 0;
													static GQuark _tmp90_label49 = 0;
													static GQuark _tmp90_label50 = 0;
													static GQuark _tmp90_label51 = 0;
													static GQuark _tmp90_label52 = 0;
													static GQuark _tmp90_label53 = 0;
													static GQuark _tmp90_label54 = 0;
													static GQuark _tmp90_label55 = 0;
													static GQuark _tmp90_label56 = 0;
													static GQuark _tmp90_label57 = 0;
													static GQuark _tmp90_label58 = 0;
													static GQuark _tmp90_label59 = 0;
													static GQuark _tmp90_label60 = 0;
													static GQuark _tmp90_label61 = 0;
													static GQuark _tmp90_label62 = 0;
													static GQuark _tmp90_label63 = 0;
													static GQuark _tmp90_label64 = 0;
													static GQuark _tmp90_label65 = 0;
													static GQuark _tmp90_label66 = 0;
													static GQuark _tmp90_label67 = 0;
													static GQuark _tmp90_label68 = 0;
													static GQuark _tmp90_label69 = 0;
													static GQuark _tmp90_label70 = 0;
													static GQuark _tmp90_label71 = 0;
													static GQuark _tmp90_label72 = 0;
													static GQuark _tmp90_label73 = 0;
													static GQuark _tmp90_label74 = 0;
													static GQuark _tmp90_label75 = 0;
													static GQuark _tmp90_label76 = 0;
													static GQuark _tmp90_label77 = 0;
													static GQuark _tmp90_label78 = 0;
													static GQuark _tmp90_label79 = 0;
													static GQuark _tmp90_label80 = 0;
													static GQuark _tmp90_label81 = 0;
													static GQuark _tmp90_label82 = 0;
													static GQuark _tmp90_label83 = 0;
													static GQuark _tmp90_label84 = 0;
													static GQuark _tmp90_label85 = 0;
													static GQuark _tmp90_label86 = 0;
													static GQuark _tmp90_label87 = 0;
													static GQuark _tmp90_label88 = 0;
													static GQuark _tmp90_label89 = 0;
													static GQuark _tmp90_label90 = 0;
													static GQuark _tmp90_label91 = 0;
													_tmp88_ = cat;
													_tmp89_ = _tmp88_;
													_tmp91_ = (NULL == _tmp89_) ? 0 : g_quark_from_string (_tmp89_);
													if (((((((_tmp91_ == ((0 != _tmp90_label0) ? _tmp90_label0 : (_tmp90_label0 = g_quark_from_static_string ("Photography")))) || (_tmp91_ == ((0 != _tmp90_label1) ? _tmp90_label1 : (_tmp90_label1 = g_quark_from_static_string ("ImageProcessing"))))) || (_tmp91_ == ((0 != _tmp90_label2) ? _tmp90_label2 : (_tmp90_label2 = g_quark_from_static_string ("Graphics"))))) || (_tmp91_ == ((0 != _tmp90_label3) ? _tmp90_label3 : (_tmp90_label3 = g_quark_from_static_string ("Video"))))) || (_tmp91_ == ((0 != _tmp90_label4) ? _tmp90_label4 : (_tmp90_label4 = g_quark_from_static_string ("VectorGraphics"))))) || (_tmp91_ == ((0 != _tmp90_label5) ? _tmp90_label5 : (_tmp90_label5 = g_quark_from_static_string ("2DGraphics"))))) || (_tmp91_ == ((0 != _tmp90_label6) ? _tmp90_label6 : (_tmp90_label6 = g_quark_from_static_string ("3DGraphics"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp92_;
																gconstpointer _tmp93_;
																const gchar* _tmp94_;
																PamacAppLinked* _tmp95_;
																_tmp92_ = self->priv->categories_cache;
																_tmp93_ = g_hash_table_lookup (_tmp92_, "Photo & Video");
																_tmp94_ = id;
																_tmp95_ = new_app;
																g_hash_table_insert ((GHashTable*) _tmp93_, _tmp94_, (PamacApp*) _tmp95_);
																break;
															}
														}
													} else if (((((_tmp91_ == ((0 != _tmp90_label7) ? _tmp90_label7 : (_tmp90_label7 = g_quark_from_static_string ("Audio")))) || (_tmp91_ == ((0 != _tmp90_label8) ? _tmp90_label8 : (_tmp90_label8 = g_quark_from_static_string ("Music"))))) || (_tmp91_ == ((0 != _tmp90_label9) ? _tmp90_label9 : (_tmp90_label9 = g_quark_from_static_string ("Midi"))))) || (_tmp91_ == ((0 != _tmp90_label10) ? _tmp90_label10 : (_tmp90_label10 = g_quark_from_static_string ("Mixer"))))) || (_tmp91_ == ((0 != _tmp90_label11) ? _tmp90_label11 : (_tmp90_label11 = g_quark_from_static_string ("Multimedia"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp96_;
																gconstpointer _tmp97_;
																const gchar* _tmp98_;
																PamacAppLinked* _tmp99_;
																_tmp96_ = self->priv->categories_cache;
																_tmp97_ = g_hash_table_lookup (_tmp96_, "Music & Audio");
																_tmp98_ = id;
																_tmp99_ = new_app;
																g_hash_table_insert ((GHashTable*) _tmp97_, _tmp98_, (PamacApp*) _tmp99_);
																break;
															}
														}
													} else if ((((((((((((((((_tmp91_ == ((0 != _tmp90_label12) ? _tmp90_label12 : (_tmp90_label12 = g_quark_from_static_string ("WebBrowser")))) || (_tmp91_ == ((0 != _tmp90_label13) ? _tmp90_label13 : (_tmp90_label13 = g_quark_from_static_string ("Email"))))) || (_tmp91_ == ((0 != _tmp90_label14) ? _tmp90_label14 : (_tmp90_label14 = g_quark_from_static_string ("Office"))))) || (_tmp91_ == ((0 != _tmp90_label15) ? _tmp90_label15 : (_tmp90_label15 = g_quark_from_static_string ("Calculator"))))) || (_tmp91_ == ((0 != _tmp90_label16) ? _tmp90_label16 : (_tmp90_label16 = g_quark_from_static_string ("Calendar"))))) || (_tmp91_ == ((0 != _tmp90_label17) ? _tmp90_label17 : (_tmp90_label17 = g_quark_from_static_string ("Clock"))))) || (_tmp91_ == ((0 != _tmp90_label18) ? _tmp90_label18 : (_tmp90_label18 = g_quark_from_static_string ("ContactManagement"))))) || (_tmp91_ == ((0 != _tmp90_label19) ? _tmp90_label19 : (_tmp90_label19 = g_quark_from_static_string ("Dictionary"))))) || (_tmp91_ == ((0 != _tmp90_label20) ? _tmp90_label20 : (_tmp90_label20 = g_quark_from_static_string ("Documentation"))))) || (_tmp91_ == ((0 != _tmp90_label21) ? _tmp90_label21 : (_tmp90_label21 = g_quark_from_static_string ("Finance"))))) || (_tmp91_ == ((0 != _tmp90_label22) ? _tmp90_label22 : (_tmp90_label22 = g_quark_from_static_string ("FlowChart"))))) || (_tmp91_ == ((0 != _tmp90_label23) ? _tmp90_label23 : (_tmp90_label23 = g_quark_from_static_string ("Presentation"))))) || (_tmp91_ == ((0 != _tmp90_label24) ? _tmp90_label24 : (_tmp90_label24 = g_quark_from_static_string ("Productivity"))))) || (_tmp91_ == ((0 != _tmp90_label25) ? _tmp90_label25 : (_tmp90_label25 = g_quark_from_static_string ("Spreadsheet"))))) || (_tmp91_ == ((0 != _tmp90_label26) ? _tmp90_label26 : (_tmp90_label26 = g_quark_from_static_string ("WordProcessor"))))) || (_tmp91_ == ((0 != _tmp90_label27) ? _tmp90_label27 : (_tmp90_label27 = g_quark_from_static_string ("Publishing"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp100_;
																gconstpointer _tmp101_;
																const gchar* _tmp102_;
																PamacAppLinked* _tmp103_;
																_tmp100_ = self->priv->categories_cache;
																_tmp101_ = g_hash_table_lookup (_tmp100_, "Productivity");
																_tmp102_ = id;
																_tmp103_ = new_app;
																g_hash_table_insert ((GHashTable*) _tmp101_, _tmp102_, (PamacApp*) _tmp103_);
																break;
															}
														}
													} else if (((((((((_tmp91_ == ((0 != _tmp90_label28) ? _tmp90_label28 : (_tmp90_label28 = g_quark_from_static_string ("Network")))) || (_tmp91_ == ((0 != _tmp90_label29) ? _tmp90_label29 : (_tmp90_label29 = g_quark_from_static_string ("Chat"))))) || (_tmp91_ == ((0 != _tmp90_label30) ? _tmp90_label30 : (_tmp90_label30 = g_quark_from_static_string ("News"))))) || (_tmp91_ == ((0 != _tmp90_label31) ? _tmp90_label31 : (_tmp90_label31 = g_quark_from_static_string ("Feed"))))) || (_tmp91_ == ((0 != _tmp90_label32) ? _tmp90_label32 : (_tmp90_label32 = g_quark_from_static_string ("Communication"))))) || (_tmp91_ == ((0 != _tmp90_label33) ? _tmp90_label33 : (_tmp90_label33 = g_quark_from_static_string ("InstantMessaging"))))) || (_tmp91_ == ((0 != _tmp90_label34) ? _tmp90_label34 : (_tmp90_label34 = g_quark_from_static_string ("IRCClient"))))) || (_tmp91_ == ((0 != _tmp90_label35) ? _tmp90_label35 : (_tmp90_label35 = g_quark_from_static_string ("Telephony"))))) || (_tmp91_ == ((0 != _tmp90_label36) ? _tmp90_label36 : (_tmp90_label36 = g_quark_from_static_string ("VideoConference"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp104_;
																gconstpointer _tmp105_;
																const gchar* _tmp106_;
																PamacAppLinked* _tmp107_;
																_tmp104_ = self->priv->categories_cache;
																_tmp105_ = g_hash_table_lookup (_tmp104_, "Communication & News");
																_tmp106_ = id;
																_tmp107_ = new_app;
																g_hash_table_insert ((GHashTable*) _tmp105_, _tmp106_, (PamacApp*) _tmp107_);
																break;
															}
														}
													} else if ((((((((((((((((_tmp91_ == ((0 != _tmp90_label37) ? _tmp90_label37 : (_tmp90_label37 = g_quark_from_static_string ("Education")))) || (_tmp91_ == ((0 != _tmp90_label38) ? _tmp90_label38 : (_tmp90_label38 = g_quark_from_static_string ("Science"))))) || (_tmp91_ == ((0 != _tmp90_label39) ? _tmp90_label39 : (_tmp90_label39 = g_quark_from_static_string ("Astronomy"))))) || (_tmp91_ == ((0 != _tmp90_label40) ? _tmp90_label40 : (_tmp90_label40 = g_quark_from_static_string ("Chemistry"))))) || (_tmp91_ == ((0 != _tmp90_label41) ? _tmp90_label41 : (_tmp90_label41 = g_quark_from_static_string ("ComputerScience"))))) || (_tmp91_ == ((0 != _tmp90_label42) ? _tmp90_label42 : (_tmp90_label42 = g_quark_from_static_string ("Electricity"))))) || (_tmp91_ == ((0 != _tmp90_label43) ? _tmp90_label43 : (_tmp90_label43 = g_quark_from_static_string ("Electronics"))))) || (_tmp91_ == ((0 != _tmp90_label44) ? _tmp90_label44 : (_tmp90_label44 = g_quark_from_static_string ("Physics"))))) || (_tmp91_ == ((0 != _tmp90_label45) ? _tmp90_label45 : (_tmp90_label45 = g_quark_from_static_string ("Engineering"))))) || (_tmp91_ == ((0 != _tmp90_label46) ? _tmp90_label46 : (_tmp90_label46 = g_quark_from_static_string ("Geography"))))) || (_tmp91_ == ((0 != _tmp90_label47) ? _tmp90_label47 : (_tmp90_label47 = g_quark_from_static_string ("Geoscience"))))) || (_tmp91_ == ((0 != _tmp90_label48) ? _tmp90_label48 : (_tmp90_label48 = g_quark_from_static_string ("Languages"))))) || (_tmp91_ == ((0 != _tmp90_label49) ? _tmp90_label49 : (_tmp90_label49 = g_quark_from_static_string ("Literature"))))) || (_tmp91_ == ((0 != _tmp90_label50) ? _tmp90_label50 : (_tmp90_label50 = g_quark_from_static_string ("Maps"))))) || (_tmp91_ == ((0 != _tmp90_label51) ? _tmp90_label51 : (_tmp90_label51 = g_quark_from_static_string ("Math"))))) || (_tmp91_ == ((0 != _tmp90_label52) ? _tmp90_label52 : (_tmp90_label52 = g_quark_from_static_string ("NumericalAnalysis"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp108_;
																gconstpointer _tmp109_;
																const gchar* _tmp110_;
																PamacAppLinked* _tmp111_;
																_tmp108_ = self->priv->categories_cache;
																_tmp109_ = g_hash_table_lookup (_tmp108_, "Education & Science");
																_tmp110_ = id;
																_tmp111_ = new_app;
																g_hash_table_insert ((GHashTable*) _tmp109_, _tmp110_, (PamacApp*) _tmp111_);
																break;
															}
														}
													} else if (((((((((((((_tmp91_ == ((0 != _tmp90_label53) ? _tmp90_label53 : (_tmp90_label53 = g_quark_from_static_string ("Games")))) || (_tmp91_ == ((0 != _tmp90_label54) ? _tmp90_label54 : (_tmp90_label54 = g_quark_from_static_string ("Game"))))) || (_tmp91_ == ((0 != _tmp90_label55) ? _tmp90_label55 : (_tmp90_label55 = g_quark_from_static_string ("ActionGame"))))) || (_tmp91_ == ((0 != _tmp90_label56) ? _tmp90_label56 : (_tmp90_label56 = g_quark_from_static_string ("ArcadeGame"))))) || (_tmp91_ == ((0 != _tmp90_label57) ? _tmp90_label57 : (_tmp90_label57 = g_quark_from_static_string ("BlocksGame"))))) || (_tmp91_ == ((0 != _tmp90_label58) ? _tmp90_label58 : (_tmp90_label58 = g_quark_from_static_string ("BoardGame"))))) || (_tmp91_ == ((0 != _tmp90_label59) ? _tmp90_label59 : (_tmp90_label59 = g_quark_from_static_string ("LogicGame"))))) || (_tmp91_ == ((0 != _tmp90_label60) ? _tmp90_label60 : (_tmp90_label60 = g_quark_from_static_string ("StrategyGame"))))) || (_tmp91_ == ((0 != _tmp90_label61) ? _tmp90_label61 : (_tmp90_label61 = g_quark_from_static_string ("RolePlaying"))))) || (_tmp91_ == ((0 != _tmp90_label62) ? _tmp90_label62 : (_tmp90_label62 = g_quark_from_static_string ("AdventureGame"))))) || (_tmp91_ == ((0 != _tmp90_label63) ? _tmp90_label63 : (_tmp90_label63 = g_quark_from_static_string ("CardGame"))))) || (_tmp91_ == ((0 != _tmp90_label64) ? _tmp90_label64 : (_tmp90_label64 = g_quark_from_static_string ("KidsGame"))))) || (_tmp91_ == ((0 != _tmp90_label65) ? _tmp90_label65 : (_tmp90_label65 = g_quark_from_static_string ("Emulator"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp112_;
																gconstpointer _tmp113_;
																const gchar* _tmp114_;
																PamacAppLinked* _tmp115_;
																_tmp112_ = self->priv->categories_cache;
																_tmp113_ = g_hash_table_lookup (_tmp112_, "Games");
																_tmp114_ = id;
																_tmp115_ = new_app;
																g_hash_table_insert ((GHashTable*) _tmp113_, _tmp114_, (PamacApp*) _tmp115_);
																break;
															}
														}
													} else if ((((((((((((((((_tmp91_ == ((0 != _tmp90_label66) ? _tmp90_label66 : (_tmp90_label66 = g_quark_from_static_string ("Utility")))) || (_tmp91_ == ((0 != _tmp90_label67) ? _tmp90_label67 : (_tmp90_label67 = g_quark_from_static_string ("Monitor"))))) || (_tmp91_ == ((0 != _tmp90_label68) ? _tmp90_label68 : (_tmp90_label68 = g_quark_from_static_string ("Accessibility"))))) || (_tmp91_ == ((0 != _tmp90_label69) ? _tmp90_label69 : (_tmp90_label69 = g_quark_from_static_string ("Archiving"))))) || (_tmp91_ == ((0 != _tmp90_label70) ? _tmp90_label70 : (_tmp90_label70 = g_quark_from_static_string ("Compression"))))) || (_tmp91_ == ((0 != _tmp90_label71) ? _tmp90_label71 : (_tmp90_label71 = g_quark_from_static_string ("ConsoleOnly"))))) || (_tmp91_ == ((0 != _tmp90_label72) ? _tmp90_label72 : (_tmp90_label72 = g_quark_from_static_string ("Core"))))) || (_tmp91_ == ((0 != _tmp90_label73) ? _tmp90_label73 : (_tmp90_label73 = g_quark_from_static_string ("DesktopSettings"))))) || (_tmp91_ == ((0 != _tmp90_label74) ? _tmp90_label74 : (_tmp90_label74 = g_quark_from_static_string ("DiscBurning"))))) || (_tmp91_ == ((0 != _tmp90_label75) ? _tmp90_label75 : (_tmp90_label75 = g_quark_from_static_string ("Settings"))))) || (_tmp91_ == ((0 != _tmp90_label76) ? _tmp90_label76 : (_tmp90_label76 = g_quark_from_static_string ("FileManager"))))) || (_tmp91_ == ((0 != _tmp90_label77) ? _tmp90_label77 : (_tmp90_label77 = g_quark_from_static_string ("Filesystem"))))) || (_tmp91_ == ((0 != _tmp90_label78) ? _tmp90_label78 : (_tmp90_label78 = g_quark_from_static_string ("FileTools"))))) || (_tmp91_ == ((0 != _tmp90_label79) ? _tmp90_label79 : (_tmp90_label79 = g_quark_from_static_string ("PackageManager"))))) || (_tmp91_ == ((0 != _tmp90_label80) ? _tmp90_label80 : (_tmp90_label80 = g_quark_from_static_string ("FileTransfer"))))) || (_tmp91_ == ((0 != _tmp90_label81) ? _tmp90_label81 : (_tmp90_label81 = g_quark_from_static_string ("HardwareSettings"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp116_;
																gconstpointer _tmp117_;
																const gchar* _tmp118_;
																PamacAppLinked* _tmp119_;
																_tmp116_ = self->priv->categories_cache;
																_tmp117_ = g_hash_table_lookup (_tmp116_, "Utilities");
																_tmp118_ = id;
																_tmp119_ = new_app;
																g_hash_table_insert ((GHashTable*) _tmp117_, _tmp118_, (PamacApp*) _tmp119_);
																break;
															}
														}
													} else if ((((((((((_tmp91_ == ((0 != _tmp90_label82) ? _tmp90_label82 : (_tmp90_label82 = g_quark_from_static_string ("Development")))) || (_tmp91_ == ((0 != _tmp90_label83) ? _tmp90_label83 : (_tmp90_label83 = g_quark_from_static_string ("IDE"))))) || (_tmp91_ == ((0 != _tmp90_label84) ? _tmp90_label84 : (_tmp90_label84 = g_quark_from_static_string ("Building"))))) || (_tmp91_ == ((0 != _tmp90_label85) ? _tmp90_label85 : (_tmp90_label85 = g_quark_from_static_string ("Construction"))))) || (_tmp91_ == ((0 != _tmp90_label86) ? _tmp90_label86 : (_tmp90_label86 = g_quark_from_static_string ("Database"))))) || (_tmp91_ == ((0 != _tmp90_label87) ? _tmp90_label87 : (_tmp90_label87 = g_quark_from_static_string ("DataVisualization"))))) || (_tmp91_ == ((0 != _tmp90_label88) ? _tmp90_label88 : (_tmp90_label88 = g_quark_from_static_string ("Debugger"))))) || (_tmp91_ == ((0 != _tmp90_label89) ? _tmp90_label89 : (_tmp90_label89 = g_quark_from_static_string ("GUIDesigner"))))) || (_tmp91_ == ((0 != _tmp90_label90) ? _tmp90_label90 : (_tmp90_label90 = g_quark_from_static_string ("Java"))))) || (_tmp91_ == ((0 != _tmp90_label91) ? _tmp90_label91 : (_tmp90_label91 = g_quark_from_static_string ("WebDevelopment"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp120_;
																gconstpointer _tmp121_;
																const gchar* _tmp122_;
																PamacAppLinked* _tmp123_;
																_tmp120_ = self->priv->categories_cache;
																_tmp121_ = g_hash_table_lookup (_tmp120_, "Development");
																_tmp122_ = id;
																_tmp123_ = new_app;
																g_hash_table_insert ((GHashTable*) _tmp121_, _tmp122_, (PamacApp*) _tmp123_);
																break;
															}
														}
													}
												}
											}
										}
										_g_object_unref0 (new_app);
										_g_ptr_array_unref0 (pkgname_apps);
									}
								}
							}
						}
						_tmp124_ = self->priv->stores_table;
						_tmp125_ = desktop_apps;
						_tmp126_ = _g_hash_table_ref0 (_tmp125_);
						g_ptr_array_add (_tmp124_, _tmp126_);
						_g_hash_table_unref0 (desktop_apps);
						_g_object_unref0 (mdata);
					}
					_g_object_unref0 (appstream_file);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp127_;
					const gchar* _tmp128_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp127_ = e;
					_tmp128_ = _tmp127_->message;
					g_warning ("appstream_plugin.vala:321: %s", _tmp128_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
}

static GPtrArray*
pamac_appstream_real_get_apps (PamacAppstreamPlugin* base)
{
	PamacAppstream * self;
	GPtrArray* _tmp0_;
	GPtrArray* result;
	self = (PamacAppstream*) base;
	_tmp0_ = self->priv->stores_table;
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static GPtrArray*
pamac_appstream_real_search (PamacAppstreamPlugin* base,
                             gchar** search_tokens,
                             gint search_tokens_length1)
{
	PamacAppstream * self;
	GPtrArray* _result_ = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* result;
	self = (PamacAppstream*) base;
	_tmp0_ = g_ptr_array_new_full ((guint) 0, NULL);
	_result_ = _tmp0_;
	_tmp1_ = self->priv->stores_table;
	{
		GPtrArray* apps_collection = NULL;
		guint apps_index = 0U;
		apps_collection = _tmp1_;
		for (apps_index = 0; apps_index < apps_collection->len; apps_index = apps_index + 1) {
			GHashTable* apps = NULL;
			apps = (GHashTable*) g_ptr_array_index (apps_collection, apps_index);
			{
				GHashTableIter iter = {0};
				GHashTable* _tmp2_;
				const gchar* repo = NULL;
				PamacApp* app = NULL;
				_tmp2_ = apps;
				g_hash_table_iter_init (&iter, _tmp2_);
				while (TRUE) {
					gconstpointer _tmp3_ = NULL;
					gconstpointer _tmp4_ = NULL;
					gboolean _tmp5_;
					PamacAppLinked* applinked = NULL;
					PamacApp* _tmp6_;
					guint match_score = 0U;
					PamacAppLinked* _tmp7_;
					gboolean _tmp8_ = FALSE;
					_tmp5_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp3_), (gpointer*) (&_tmp4_));
					repo = (const gchar*) _tmp3_;
					app = (PamacApp*) _tmp4_;
					if (!_tmp5_) {
						break;
					}
					_tmp6_ = app;
					applinked = PAMAC_IS_APP_LINKED (_tmp6_) ? ((PamacAppLinked*) _tmp6_) : NULL;
					_tmp7_ = applinked;
					match_score = pamac_app_linked_search_matches_all (_tmp7_, search_tokens, (gint) search_tokens_length1);
					if (match_score > ((guint) 0)) {
						_tmp8_ = TRUE;
					} else {
						PamacApp* _tmp9_;
						const gchar* _tmp10_;
						const gchar* _tmp11_;
						const gchar* _tmp12_;
						_tmp9_ = app;
						_tmp10_ = pamac_app_get_id (_tmp9_);
						_tmp11_ = _tmp10_;
						_tmp12_ = search_tokens[0];
						_tmp8_ = string_contains (_tmp11_, _tmp12_);
					}
					if (_tmp8_) {
						GPtrArray* _tmp13_;
						PamacApp* _tmp14_;
						_tmp13_ = _result_;
						_tmp14_ = app;
						g_ptr_array_add (_tmp13_, _tmp14_);
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}

static GPtrArray*
pamac_appstream_real_get_pkgname_apps (PamacAppstreamPlugin* base,
                                       const gchar* pkgname)
{
	PamacAppstream * self;
	GPtrArray* apps = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	GPtrArray* result;
	self = (PamacAppstream*) base;
	g_return_val_if_fail (pkgname != NULL, NULL);
	_tmp0_ = self->priv->pkgname_apps_cache;
	_tmp1_ = g_hash_table_lookup (_tmp0_, pkgname);
	_tmp2_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp1_);
	apps = _tmp2_;
	_tmp3_ = apps;
	if (_tmp3_ == NULL) {
		GPtrArray* _tmp4_;
		_tmp4_ = g_ptr_array_new_full ((guint) 0, NULL);
		_g_ptr_array_unref0 (apps);
		apps = _tmp4_;
	}
	result = apps;
	return result;
}

static GHashTable*
pamac_appstream_real_get_category_apps (PamacAppstreamPlugin* base,
                                        const gchar* category)
{
	PamacAppstream * self;
	GHashTable* apps_table = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* result;
	self = (PamacAppstream*) base;
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = self->priv->categories_cache;
	_tmp1_ = g_hash_table_lookup (_tmp0_, category);
	_tmp2_ = _g_hash_table_ref0 ((GHashTable*) _tmp1_);
	apps_table = _tmp2_;
	_tmp3_ = apps_table;
	if (_tmp3_ == NULL) {
		GHashFunc _tmp4_;
		GEqualFunc _tmp5_;
		GHashTable* _tmp6_;
		_tmp4_ = g_str_hash;
		_tmp5_ = g_str_equal;
		_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, NULL, NULL);
		_g_hash_table_unref0 (apps_table);
		apps_table = _tmp6_;
		if (g_strcmp0 (category, "Featured") == 0) {
			GPtrArray* names = NULL;
			GPtrArray* _tmp7_;
			GPtrArray* _tmp8_;
			gchar* _tmp9_;
			GPtrArray* _tmp10_;
			gchar* _tmp11_;
			GPtrArray* _tmp12_;
			gchar* _tmp13_;
			GPtrArray* _tmp14_;
			gchar* _tmp15_;
			GPtrArray* _tmp16_;
			gchar* _tmp17_;
			GPtrArray* _tmp18_;
			gchar* _tmp19_;
			GPtrArray* _tmp20_;
			gchar* _tmp21_;
			GPtrArray* _tmp22_;
			gchar* _tmp23_;
			GPtrArray* _tmp24_;
			gchar* _tmp25_;
			GPtrArray* _tmp26_;
			gchar* _tmp27_;
			GPtrArray* _tmp28_;
			gchar* _tmp29_;
			GPtrArray* _tmp30_;
			gchar* _tmp31_;
			GPtrArray* _tmp32_;
			GHashTable* _tmp43_;
			gchar* _tmp44_;
			GHashTable* _tmp45_;
			GHashTable* _tmp46_;
			_tmp7_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			names = _tmp7_;
			_tmp8_ = names;
			_tmp9_ = g_strdup ("firefox");
			g_ptr_array_add (_tmp8_, _tmp9_);
			_tmp10_ = names;
			_tmp11_ = g_strdup ("vlc");
			g_ptr_array_add (_tmp10_, _tmp11_);
			_tmp12_ = names;
			_tmp13_ = g_strdup ("gimp");
			g_ptr_array_add (_tmp12_, _tmp13_);
			_tmp14_ = names;
			_tmp15_ = g_strdup ("shotwell");
			g_ptr_array_add (_tmp14_, _tmp15_);
			_tmp16_ = names;
			_tmp17_ = g_strdup ("inkscape");
			g_ptr_array_add (_tmp16_, _tmp17_);
			_tmp18_ = names;
			_tmp19_ = g_strdup ("blender");
			g_ptr_array_add (_tmp18_, _tmp19_);
			_tmp20_ = names;
			_tmp21_ = g_strdup ("libreoffice-still");
			g_ptr_array_add (_tmp20_, _tmp21_);
			_tmp22_ = names;
			_tmp23_ = g_strdup ("telegram-desktop");
			g_ptr_array_add (_tmp22_, _tmp23_);
			_tmp24_ = names;
			_tmp25_ = g_strdup ("cura");
			g_ptr_array_add (_tmp24_, _tmp25_);
			_tmp26_ = names;
			_tmp27_ = g_strdup ("arduino");
			g_ptr_array_add (_tmp26_, _tmp27_);
			_tmp28_ = names;
			_tmp29_ = g_strdup ("retroarch");
			g_ptr_array_add (_tmp28_, _tmp29_);
			_tmp30_ = names;
			_tmp31_ = g_strdup ("virtualbox");
			g_ptr_array_add (_tmp30_, _tmp31_);
			_tmp32_ = names;
			{
				GPtrArray* name_collection = NULL;
				guint name_index = 0U;
				name_collection = _tmp32_;
				for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
					const gchar* name = NULL;
					name = (const gchar*) g_ptr_array_index (name_collection, name_index);
					{
						GPtrArray* apps = NULL;
						GHashTable* _tmp33_;
						const gchar* _tmp34_;
						gconstpointer _tmp35_;
						GPtrArray* _tmp36_;
						GPtrArray* _tmp37_;
						_tmp33_ = self->priv->pkgname_apps_cache;
						_tmp34_ = name;
						_tmp35_ = g_hash_table_lookup (_tmp33_, _tmp34_);
						apps = (GPtrArray*) _tmp35_;
						_tmp36_ = apps;
						if (_tmp36_ == NULL) {
							continue;
						}
						_tmp37_ = apps;
						{
							GPtrArray* app_collection = NULL;
							guint app_index = 0U;
							app_collection = _tmp37_;
							for (app_index = 0; app_index < app_collection->len; app_index = app_index + 1) {
								PamacApp* app = NULL;
								app = (PamacApp*) g_ptr_array_index (app_collection, app_index);
								{
									GHashTable* _tmp38_;
									PamacApp* _tmp39_;
									const gchar* _tmp40_;
									const gchar* _tmp41_;
									PamacApp* _tmp42_;
									_tmp38_ = apps_table;
									_tmp39_ = app;
									_tmp40_ = pamac_app_get_id (_tmp39_);
									_tmp41_ = _tmp40_;
									_tmp42_ = app;
									g_hash_table_insert (_tmp38_, _tmp41_, _tmp42_);
								}
							}
						}
					}
				}
			}
			_tmp43_ = self->priv->categories_cache;
			_tmp44_ = g_strdup (category);
			_tmp45_ = apps_table;
			_tmp46_ = _g_hash_table_ref0 (_tmp45_);
			g_hash_table_insert (_tmp43_, _tmp44_, _tmp46_);
			_g_ptr_array_unref0 (names);
		}
	}
	result = apps_table;
	return result;
}

static void
_g_hash_table_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}

static void
_g_ptr_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}

static GObject *
pamac_appstream_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PamacAppstream * self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	parent_class = G_OBJECT_CLASS (pamac_appstream_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_APPSTREAM, PamacAppstream);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->repos_names);
	self->priv->repos_names = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_hash_table_unref0_);
	_g_ptr_array_unref0 (self->priv->stores_table);
	self->priv->stores_table = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_hash_table_unref0_);
	_g_hash_table_unref0 (self->priv->categories_cache);
	self->priv->categories_cache = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->pkgname_apps_cache);
	self->priv->pkgname_apps_cache = _tmp7_;
	return obj;
}

static void
pamac_appstream_class_init (PamacAppstreamClass * klass,
                            gpointer klass_data)
{
	pamac_appstream_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacAppstream_private_offset);
	G_OBJECT_CLASS (klass)->constructor = pamac_appstream_constructor;
	G_OBJECT_CLASS (klass)->finalize = pamac_appstream_finalize;
}

static void
pamac_appstream_pamac_appstream_plugin_interface_init (PamacAppstreamPluginIface * iface,
                                                       gpointer iface_data)
{
	pamac_appstream_pamac_appstream_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->load = (void (*) (PamacAppstreamPlugin*, GPtrArray*)) pamac_appstream_real_load;
	iface->get_apps = (GPtrArray* (*) (PamacAppstreamPlugin*)) pamac_appstream_real_get_apps;
	iface->search = (GPtrArray* (*) (PamacAppstreamPlugin*, gchar**, gint)) pamac_appstream_real_search;
	iface->get_pkgname_apps = (GPtrArray* (*) (PamacAppstreamPlugin*, const gchar*)) pamac_appstream_real_get_pkgname_apps;
	iface->get_category_apps = (GHashTable* (*) (PamacAppstreamPlugin*, const gchar*)) pamac_appstream_real_get_category_apps;
}

static void
pamac_appstream_instance_init (PamacAppstream * self,
                               gpointer klass)
{
	self->priv = pamac_appstream_get_instance_private (self);
}

static void
pamac_appstream_finalize (GObject * obj)
{
	PamacAppstream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_APPSTREAM, PamacAppstream);
	_g_ptr_array_unref0 (self->priv->stores_table);
	_g_hash_table_unref0 (self->priv->pkgname_apps_cache);
	_g_hash_table_unref0 (self->priv->categories_cache);
	_g_ptr_array_unref0 (self->priv->repos_names);
	G_OBJECT_CLASS (pamac_appstream_parent_class)->finalize (obj);
}

static GType
pamac_appstream_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacAppstreamClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_appstream_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacAppstream), 0, (GInstanceInitFunc) pamac_appstream_instance_init, NULL };
	static const GInterfaceInfo pamac_appstream_plugin_info = { (GInterfaceInitFunc) pamac_appstream_pamac_appstream_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pamac_appstream_type_id;
	pamac_appstream_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacAppstream", &g_define_type_info, 0);
	g_type_add_interface_static (pamac_appstream_type_id, PAMAC_TYPE_APPSTREAM_PLUGIN, &pamac_appstream_plugin_info);
	PamacAppstream_private_offset = g_type_add_instance_private (pamac_appstream_type_id, sizeof (PamacAppstreamPrivate));
	return pamac_appstream_type_id;
}

GType
pamac_appstream_get_type (void)
{
	static volatile gsize pamac_appstream_type_id__once = 0;
	if (g_once_init_enter (&pamac_appstream_type_id__once)) {
		GType pamac_appstream_type_id;
		pamac_appstream_type_id = pamac_appstream_get_type_once ();
		g_once_init_leave (&pamac_appstream_type_id__once, pamac_appstream_type_id);
	}
	return pamac_appstream_type_id__once;
}

GType
register_plugin (GModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	result = PAMAC_TYPE_APPSTREAM;
	return result;
}

